%% Elaborazione dei dati per il calcolo delle FRF sperimentali

% % f=[0.1 0.13 0.18 0.23 0.3 0.4 0.53 0.7 0.93 1.2 1.6 2.2 2.8 3.8 5 6.6 8.7 11.5 15 20];
% 
% ff=20;
% 
% f=20;
% 
% % rivedi da 2.2 Hz a 6.9 Hz escuso 6.9, rivedi 15 
% acq = xlsread('020.xlsx','Pos_Control');
% 
% 
% t=5/f;
% dt=1/4000;
% 
% 
% time=acq(:,1);
% 
% time0=time(1);
% 
% for i=1:length(time)
%     time(i)=time(i)-time0;
% end
% 
% data.P_1=acq(:,2);
% data.P_2=acq(:,3);
% data.Spool_FB=acq(:,4);
% data.Spool_Cmd=acq(:,5);
% data.Load=acq(:,16);
% data.PosSet=acq(:,6);
% data.Pos_Feedback=acq(:,15);
% 
% % %%
% % 
% % 
% % plot(time,data.Pos_Feedback)
% % hold on
% % plot(time,data.PosSet)
% 
% 
% close all
% for i=2:length(data.PosSet)-1
%     
%     % inizio sinusoide
%     if data.PosSet(i)==0 && (data.PosSet(i+1)<0 || data.PosSet(i+1)>0)  
%        j=i;
%     end
%     
% end
% 
% for i=1:length(data.PosSet)-j
%     PosSet1(i)=data.PosSet(j-1+i);
% end
% 
% for i=1:length(data.Pos_Feedback)-j
%     Pos_Feedback1(i)=data.Pos_Feedback(j-1+i);
% end
% 
% for i=1:length(time)-j
%     time1(i)=time(j-1+i);
% end
% 
% time0=time1(1);
% 
% for i=1:length(time1)
%     time1(i)=time1(i)-time0;
% end
% 
% % fine sinusoide
% 
% for i=1:length(time1)-1
%     if time1(i)==t || (time1(i+1)>t && time1(i)<t)
%         k=i;
%     end
% end
% 
% 
% for i=1:k
%     PosSet2(i)=PosSet1(i);
% end
% 
% for i=1:k
%     Pos_Feedback2(i)=Pos_Feedback1(i);
% end
% 
% for i=1:k
%     time2(i)=time1(i);
% end
% 
% plot(time2,PosSet2)
% hold on
% plot(time2,Pos_Feedback2)

%% FRF sperimentale calcolo ampiezza e fase

% Re_in = 2/time2(end)*trapz(time2,sin(2*pi*f*time2).*(PosSet2));
% Im_in = 2/time2(end)*trapz(time2,cos(2*pi*f*time2).*(PosSet2));
% amp_in = sqrt(Re_in^2+Im_in^2);
% phase_in = angle(Re_in+1i*Im_in);
% 
% % Calcolo dell'ampiezza e della fase del segnale di output
% Re_out = 2/time2(end)*trapz(time2,sin(2*pi*f*time2).*(Pos_Feedback2));
% Im_out = 2/time2(end)*trapz(time2,cos(2*pi*f*time2).*(Pos_Feedback2));
% amp_out = sqrt(Re_out^2+Im_out^2);
% phase_out = angle(Re_out+1i*Im_out);
% 
% % Calcolo il modulo e la fase della funzione di risposta in frequenza
% Mod = 20*log10(amp_out/amp_in);
% Phase = ((wrapTo2Pi(phase_out-phase_in))-2*pi)*180/pi;
% 

%% Salvataggio risposta sperimentale su file

% load('FRF10_POS.mat')
% 
% FRF10.Mod10(ff)=Mod;
% FRF10.Phase10(ff)=Phase;
% 
% save("FRF10_POS.mat","FRF10","-mat")

%% 

close all
clc

dt=1/4000;

f=[0.1 0.13 0.18 0.23 0.3 0.4 0.53 0.7 0.93 1.2 1.6 2.2 2.8 3.8 5 6.6 8.7 11.5 15 20];

amp=5;

for i=1:length(f)

time=linspace(0,5*1/f(i),5/f(i)*1/dt)';
StopTime=time(end);

Pos_SET=amp*sin(2*pi*f(i)*time);

sim("Pos_Cntrl.slx")

Re_in = 2/time(end)*trapz(time,sin(2*pi*f(i)*time).*Pos_SET);
Im_in = 2/time(end)*trapz(time,cos(2*pi*f(i)*time).*Pos_SET);
amp_in = sqrt(Re_in^2+Im_in^2);
phase_in = angle(Re_in+1i*Im_in);

% Calcolo dell'ampiezza e della fase del segnale di output
Re_out = 2/tout(end)*trapz(tout,sin(2*pi*f(i)*tout).*(x_FB));
Im_out = 2/tout(end)*trapz(tout,cos(2*pi*f(i)*tout).*(x_FB));
amp_out = sqrt(Re_out^2+Im_out^2);
phase_out = angle(Re_out+1i*Im_out);

% Calcolo il modulo e la fase della funzione di risposta in frequenza
ModS_5(i) = 20*log10(amp_out/amp_in);
PhaseS_5(i) = ((wrapTo2Pi(phase_out-phase_in))-2*pi)*180/pi;

end


amp=10;

for i=1:length(f)

time=linspace(0,5*1/f(i),5/f(i)*1/dt)';
StopTime=time(end);

Pos_SET=amp*sin(2*pi*f(i)*time);

sim("Pos_Cntrl.slx")

Re_in = 2/time(end)*trapz(time,sin(2*pi*f(i)*time).*Pos_SET);
Im_in = 2/time(end)*trapz(time,cos(2*pi*f(i)*time).*Pos_SET);
amp_in = sqrt(Re_in^2+Im_in^2);
phase_in = angle(Re_in+1i*Im_in);

% Calcolo dell'ampiezza e della fase del segnale di output
Re_out = 2/tout(end)*trapz(tout,sin(2*pi*f(i)*tout).*(x_FB));
Im_out = 2/tout(end)*trapz(tout,cos(2*pi*f(i)*tout).*(x_FB));
amp_out = sqrt(Re_out^2+Im_out^2);
phase_out = angle(Re_out+1i*Im_out);

% Calcolo il modulo e la fase della funzione di risposta in frequenza
ModS_10(i) = 20*log10(amp_out/amp_in);
PhaseS_10(i) = ((wrapTo2Pi(phase_out-phase_in))-2*pi)*180/pi;

end

%%
close all


load('FRF5_POS.mat')
load('FRF10_POS.mat')

f=[0.1 0.13 0.18 0.23 0.3 0.4 0.53 0.7 0.93 1.2 1.6 2.2 2.8 3.8 5 6.6 8.7 11.5 15 20];


tiledlayout(2,1);
nexttile
semilogx(f,FRF5.Mod5-FRF5.Mod5(1),'-o')
hold on
semilogx(f,ModS_5-ModS_5(1),LineWidth=2)
hold on
semilogx(f,-3*ones(length(FRF5.Mod5)),'LineWidth',2,'Color','#EDB120')
grid on
legend('3% sperimentale','3% simulato')
ylabel('|x_{Fb}/x_{Set}|_{dB}')
xlabel('f [Hz]')
set(gca,'FontSize',14)

nexttile
semilogx(f,FRF5.Phase5,'-o')
hold on
semilogx(f,PhaseS_5,LineWidth=2)
grid on
legend('3% sperimentale','3% simulato')
ylabel('φ [°]')
xlabel('f [Hz]')
set(gca,'FontSize',14)
 
figure(2)

tiledlayout(2,1);
nexttile
semilogx(f,FRF10.Mod10-FRF10.Mod10(1),'-o')
hold on
semilogx(f,ModS_10-ModS_10(1),LineWidth=2)
hold on
semilogx(f,-3*ones(length(FRF5.Mod5)),'LineWidth',2,'Color','#EDB120')
grid on
legend('7% sperimentale','7% simulato')
ylabel('|x_{Fb}/x_{Set}|_{dB}')
xlabel('f [Hz]')
set(gca,'FontSize',14)

nexttile
semilogx(f,FRF10.Phase10,'-o')
hold on
semilogx(f,PhaseS_10,LineWidth=2)
grid on
legend('7% sperimentale','7% simulato')
ylabel('φ [°]')
xlabel('f [Hz]')
set(gca,'FontSize',14)

